unit ConsoleMAIN;
// ====================================================================
(*
                     
               

    ConsoleMAIN    
      ,   Switch .
    ,       
   , ALARM  GRID ,    .
      ,  
      ,     
          
       ()    .
   ,    ,   
       .
   // -----------------------------------------------------
    3.7. ()  , , , 2017..2020 .
               () Source code  ..
     11.01.2020
*)
// ====================================================================

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons, Menus,
  //  
  CommonDEF03, CommonDAT03, CommonSRV03,
  //  
  ImgLoadSave03, DTF03, CustomScope03, RingScope03,
  LineScope03, Oscillograph03, SpectrScopes03, SwitchScope03,
  DnAlarm03, DnGridEd03;

// =========================================================================
//        (DTF)
//   . ( !)
// 11.01.2020
// =========================================================================
type TSpectrData = record
    Scope_Indx    : integer;           //   
    Scope_Title   : string;            //  
    Signal_MaxPnt : integer;           //     
    Signal_ArrIdx : integer;           //    
    Signal_ArrY   : array of extended; //   
    Spectr_Arr    : TArrSpectr;        //   
end;

// =========================================================================
//    ( !)
// =========================================================================
type
  TConsoleForm = class(TForm)
    Panel1: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    Label1: TLabel;
    PageControl1: TPageControl;
    TabSopes: TTabSheet;
    TabSpectr: TTabSheet;
    PanelSpectr: TPanel;
    Image1: TImage;
    PanelOS2: TPanel;
    PanelOsc02CTRL: TPanel;
    edYMax: TEdit;
    edY1Alarm: TEdit;
    edY2Alarm: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    spbuttAplyAmp: TSpeedButton;
    spbuttOptimalScale: TSpeedButton;
    spbuttClearHistory: TSpeedButton;
    cbboxSelectSensor: TComboBox;
    PopupMenuLR: TPopupMenu;
    menuHidenShow: TMenuItem;
    menuStyle: TMenuItem;
    menuTranparent: TMenuItem;
    Label2: TLabel;
    StTxtDFTTime: TStaticText;
    Label12: TLabel;
    StTxtFullTime: TStaticText;
    Label7: TLabel;
    stxtGrmNum: TStaticText;
    Label13: TLabel;
    stxtGrmFreq: TStaticText;
    Label11: TLabel;
    ScrollBox1: TScrollBox;
    Label3: TLabel;
    PrBarExtracts: TProgressBar;
    ExtractPanel: TPanel;
    chckOs01OnOf: TCheckBox;
    chckAlarmOnOf: TCheckBox;
    Label4: TLabel;
    chckGridOnOf: TCheckBox;
    spbtnVisibleAllScope: TSpeedButton;
    cmbboxCTRL: TComboBox;
    Label14: TLabel;
    // ----------------------------------
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure spbuttAplyAmpClick(Sender: TObject);
    procedure cbboxSelectSensorClick(Sender: TObject);
    procedure spbuttClearHistoryClick(Sender: TObject);
    procedure spbuttOptimalScaleClick(Sender: TObject);
    procedure menuHidenShowClick(Sender: TObject);
    procedure menuStyleClick(Sender: TObject);
    procedure menuTranparentClick(Sender: TObject);
    procedure chckOs01OnOfClick(Sender: TObject);
    procedure chckAlarmOnOfClick(Sender: TObject);
    procedure cmbboxCTRLClick(Sender: TObject);
    procedure chckGridOnOfClick(Sender: TObject);
    procedure spbtnVisibleAllScopeClick(Sender: TObject);
    // ----------------------------------
  private
    function ClickIndByImgXY(X,Y : integer): integer;
    // ----------------------------------
    //       
    procedure SetCTRLs (RqSOBJ : TObject; RqCTRL : integer);
    // ----------------------------------
    //  SelectInd   
    procedure SetSelectInd(Indx : integer);
    // ----------------------------------
    //    
    procedure SetCommonScopeParam (ScopeIndx : integer);
    //      
    procedure SetLineScopeParam (ScopeIndx : integer);
    //     
    procedure SetRingScopeParam (ScopeIndx : integer);
    //    Switch 
    procedure SetSwitchScopeParam (ScopeIndx : integer);
    //     
    procedure SetOscParam (RqOsc : TOscillograph; ScopeIndx : integer);
    //     ALARM - 
    procedure SetAlarmParam (RqAlarm : TDnAlarm; ScopeIndx : integer);
    //    GRID - 
    procedure SetGRIDParam (RqGRID : TDnGridEd;  ScopeIndx : integer);
    //       
    procedure SetGrmlOscParam (RqOsc     : TOscillograph;
                               ScopeIndx : integer;
                               GrmIndx   : integer);
    // ----------------------------------
    //   "   "
    procedure  SpectrLoad(Sender : TObject; ArrGrm : TArrSpectr);
    //   "   Free"
    procedure SpecrtDestroy(Sender : TObject);
    //   "  "
    procedure ShowSelectGrm(Sender: TObject;
                            Num : integer; ArrGrm : TArrSpectr);
    //                                   
    procedure AddSignalPoint(RqVal : extended;
                         var RqSpectrData : TSpectrData);
    //         
    procedure ShowSpectrScope(var RqSpectrData : TSpectrData);
    // ----------------------------------

    procedure CreateSpectrograph();

    //     
    //    
    procedure InitSpectrograph(SelectInd : integer);





  public
    // ----------------------------------
    //      
    procedure ShowSensors();

    function OpenConsole(RqAppInd : integer) : integer;

    procedure CloseConsole();

  end;

var
  ConsoleForm: TConsoleForm;

// =========================================================================
// =========================================================================
implementation
{$R *.dfm}
// =========================================================================
// =========================================================================
// 03.01.2018
//    (False)
//  (True)  ,  
//    
const HidenSpectrTab = True;

// =========================================================================
// =========================================================================
//          !!!
//    ,   ,
//    
// =========================================================================
// =========================================================================

// =========================================================================
//  11.01.2020
//      
// =========================================================================
//  -  /   *.jpg
var ImgLoadSave1 : TLoadSaveImage;

// =========================================================================
//  11.01.2020
//          
// =========================================================================
//     (DTF)
var DTF03       : TDTF03;

//     
var SpectrScope : TSpectrScope;

//  -   
var Osc02       : TOscillograph;

//   
var Spectr_Inx  : integer;

//    
var Spectr_MaxAmp : extended;

//    DTF   
var SpectrData  : TSpectrData;

// =========================================================================
//  11.01.2020
//          
// =========================================================================
//  - 
var Osc01     : TOscillograph;

//  ALARM - 
var ALARM01   : TDnAlarm;

//  GRID - 
var GRID01    : TDnGridEd;

//   GRID -     
var GRID01_ValueRow : integer;

// =========================================================================
//  11.01.2020
//       () 
//        .
//    CommonDAT03.AllPtScopeArr.  CurrAppIndx 
//  CurrPtApp      
//    .
// --------------------
//   
//  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
// --------------------
//   () 
var CurrAppIndx    : integer;

//   () 
var CurrPtApp      : TPtApp;

// =========================================================================
//  11.01.2020
//       () 
// =========================================================================
//    (    )
var SelectInd : integer;

//       
var ModifyInd : integer;

// =========================================================================
//  11.01.2020
//    
// =========================================================================
//     
var FullStamps  :  TTimeStampsMM;

//    
var DFTStamps   :  TTimeStampsMM;

// =========================================================================
// =========================================================================
//
//                       
//                  
//
// =========================================================================
// =========================================================================
//              L,R,S - 
// =========================================================================
// -------------------------------------------------------------------------
// 11.01.2020
//     L,R,S - 
procedure TConsoleForm.SetCommonScopeParam (ScopeIndx : integer);
var DESC  : TAppScope;
    SOBJ  : TObject;
begin
  // -------------------
  //   
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not GetScopeDescSobj(CurrPtApp, ScopeIndx, DESC, SOBJ) then Exit;
  // -------------------
  with (SOBJ as TCustomScope)
  do begin
    // -------------------
    ScopeName := DESC.Title;                //  
    XBeg := DESC.Xb;                        // X -   
    YBeg := DESC.Yb;                        // Y -   
    Measure := DESC.Meas;                   //  
    // -------------------
    //  
    MaxScope := DESC.Max;                   //  
    P2Wall:= DESC.P2R;                      //  (+)  
    P1Wall:= DESC.P1Y;                      //  (+)  
    //  
    MinScope := DESC.Min;                   //  
    N2Wall := DESC.N2R;                     //  (-)  
    N1Wall := DESC.N1Y;                     //  (-)  
    // -------------------
    WallStyle := TWallStyle(DESC.WS);       //  
    // -------------------
    //  
    Compact := DESC.Compact;                //  
    Transparent := DESC.Transp;             // 
    /// -------------------
    //    
    NumLPF := DESC.NumLPF;
    //     (msec)
    //    (-1  0)
    Grm1 := DESC.Grm1P;
    // -------------------
    Value  := DESC.Value;                   //  
    // -------------------
    case WallStyle of
    wsDam :  cmbboxCTRL.ItemIndex := 1;     //  
    wsLimit :  cmbboxCTRL.ItemIndex := 0;   //  
    else cmbboxCTRL.ItemIndex := 0;         //  
    end;
    // ---------------------
    // 23.02.2020
    //   
    // ---------------------
    // L-
    if (SOBJ is TLineScope) and (DESC.MinLX > 0)
    then begin
      with (SOBJ as TLineScope)
      do begin
        MinScopeWidth := DESC.MinLX;
      end;
    end;
    // -------------------
    Visible := True;
    // -------------------

  end;
end;
// -------------------------------------------------------------------------
// 11.01.2020
//     Line - 
procedure TConsoleForm.SetLineScopeParam (ScopeIndx : integer);
begin
  //     L,R,S - 
  SetCommonScopeParam (ScopeIndx);
end;
// -------------------------------------------------------------------------
// 11.01.2020
//     Ring - 
procedure TConsoleForm.SetRingScopeParam (ScopeIndx : integer);
begin
  //     L,R,S - 
  SetCommonScopeParam (ScopeIndx);
end;
// -------------------------------------------------------------------------
// 11.01.2020
//     Switch - 
procedure TConsoleForm.SetSwitchScopeParam (ScopeIndx : integer);
var DESC  : TAppScope;
    SOBJ  : TObject;
begin
  // --------------------
  //   
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not GetScopeDescSobj(CurrPtApp, ScopeIndx, DESC, SOBJ) then Exit;
  // -------------------
  //     L,R,S - 
  SetCommonScopeParam (ScopeIndx);
  //     S - 
  with (SOBJ as TSwitchScope)
  do begin
    // -------------------
    MinScope := DESC.Min;
    MaxScope := DESC.Max;
  end;
end;
// =========================================================================
//             
// =========================================================================
// -------------------------------------------------------------------------
// 11.01.2020
//     
procedure TConsoleForm.SetOscParam (RqOsc  : TOscillograph;
                                    ScopeIndx : integer);
var DESC  : TAppScope;
begin
    // --------------------
    //   
    if not Assigned(RqOsc) then Exit;
    if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
    if not (GetScopeDESC(CurrPtApp, ScopeIndx, DESC)) then Exit;
    // -------------------
    //   
    RqOsc.Title := DESC.Title;
    RqOsc.YMes  := DESC.Meas;
    //   
    if Abs(DESC.Max) >= Abs(DESC.Min)
    then RqOsc.YMax := Abs(DESC.Max)
    else RqOsc.YMax := Abs(DESC.Min);
    // -------------------
    //  
    RqOsc.P2Wall:= DESC.P2R;    //  (+)  
    RqOsc.P1Wall:= DESC.P1Y;    //  (+)  
    //  
    RqOsc.N2Wall := DESC.N2R;   //  (-)  
    RqOsc.N1Wall := DESC.N1Y;   //  (-)  
    //    
    RqOsc.WallStyle := oswsDam;
    // -------------------
    //     110   YMax
    RqOsc.YMax := RqOsc.YMax * 1.1;
    // -------------------
    //  
    RqOsc.Clear;
    // -------------------
end;
// -------------------------------------------------------------------------
// 11.01.2020
//     ALARM - 
procedure TConsoleForm.SetAlarmParam (RqAlarm   : TDnAlarm;
                                      ScopeIndx : integer);
var DESC  : TAppScope;
    SOBJ  : TObject;
begin
    // -------------------
    //  
    if not Assigned(RqAlarm) then Exit;
    if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
    if not GetScopeDescSobj(CurrPtApp, ScopeIndx, DESC, SOBJ) then Exit;
    // -------------------
    //   
    RqAlarm.Title := DESC.Title;
    // -------------------
    //  
    RqAlarm.P2Wall:= DESC.P2R;     //  (+)  
    RqAlarm.P1Wall:= DESC.P1Y;     //  (+)  
    //  
    RqAlarm.N2Wall := DESC.N2R;    //  (-)  
    RqAlarm.N1Wall := DESC.N1Y;    //  (-)  
    // -------------------
    //  
    RqAlarm.YMes  := DESC.Meas;
    // -------------------
    //     
    with (SOBJ as TCustomScope)
    do begin
         case WallStyle of
           wsDam   : begin  //    
                        RqAlarm.AlarmMode    := alrmDam;
                        cmbboxCTRL.ItemIndex := 1;
                     end;
           wsLimit : begin  //    
                        RqAlarm.AlarmMode    := alrmLimit;
                        cmbboxCTRL.ItemIndex := 2;
                     end;
           else begin       //  
               RqAlarm.AlarmMode    := alrmNotUse;
               cmbboxCTRL.ItemIndex := 0;
           end;
         end;
    end;
    // -------------------
    //  ALARM - 
    RqAlarm.Clear;
    // -------------------
end;
// -------------------------------------------------------------------------
// 11.01.2020
//    GRID - 
procedure TConsoleForm.SetGRIDParam (RqGRID    : TDnGridEd;
                                     ScopeIndx : integer);
var DESC  : TAppScope;
    wM    : string;
begin
  // -------------------
  //  
  if not Assigned(RqGRID) then Exit;
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not (GetScopeDESC(CurrPtApp, ScopeIndx, DESC)) then Exit;
  // -------------------
  wM  := DESC.Meas;
  with RqGRID
  do begin
    GridTitle := ' ' + DESC.Title;
    CellsStr[1,1] := IntToStr(DESC.Xb);
    CellsStr[1,2] := IntToStr(DESC.Yb);
    // ----------
    CellsStr[1,3] := FloatToStr(DESC.Min) + ' (' + wM + ')';
    CellsStr[1,4] := FloatToStr(DESC.N2R) + ' (' + wM + ')';
    CellsStr[1,5] := FloatToStr(DESC.N1Y) + ' (' + wM + ')';
    // ----------
    CellsStr[1,GRID01_ValueRow] := '';
    // ----------
    CellsStr[1,7] := FloatToStr(DESC.P1Y) + ' (' + wM + ')';
    CellsStr[1,8] := FloatToStr(DESC.P2R) + ' (' + wM + ')';
    CellsStr[1,9] := FloatToStr(DESC.Max) + ' (' + wM + ')';
    // ----------
    if DESC.NumLPF > 0
    then CellsStr[1,10] := IntToStr(DESC.NumLPF)
    else CellsStr[1,10] := ' ';
    if DESC.Grm1P > 0
    then CellsStr[1,11] := FloatToStr(DESC.Grm1P)
    else CellsStr[1,11] := ' ';
  end;
  // -------------------
end;
// -------------------------------------------------------------------------
// 11.01.2020
//        
procedure TConsoleForm.SetGrmlOscParam (RqOsc     : TOscillograph;
                                        ScopeIndx : integer;
                                        GrmIndx   : integer);
var DESC  : TAppScope;
    SOBJ  : TObject;
begin
    // -------------------
    //  
    if not Assigned(RqOsc) then Exit;
    if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
    if not GetScopeDescSobj(CurrPtApp, ScopeIndx, DESC, SOBJ) then Exit;
    // -------------------
    if DESC.Grm1P > 0
    then begin
       //        
       RqOsc.Title := DESC.Title
                   + ' //      : '
                   + IntToStr(GrmIndx);
       RqOsc.YMes  := DESC.Meas;
       // -------------------
       //   
       if Abs(DESC.Max) >= Abs(DESC.Min)
       then RqOsc.YMax := Abs(DESC.Max)
       else RqOsc.YMax := Abs(DESC.Min);
       // -------------------
       //      
       RqOsc.P1Wall := DESC.P1Y;
       RqOsc.P2Wall := DESC.P2R;
       edYMax.Text := FloatToStr(RqOsc.YMax);
       edY1Alarm.Text := FloatToStr(RqOsc.P1Wall);  //  
       edY2Alarm.Text := FloatToStr(RqOsc.P2Wall);  //  
       // -------------------
       //     110   YMax
       RqOsc.YMax := RqOsc.YMax * 1.1;
       // -------------------
       //   - 
       TabSpectr.TabVisible := True;
       // -------------------
    end
    else begin
        // -------------------
        //   
        StTxtDFTTime.Caption := '';
        RqOsc.Title := '';
        RqOsc.YMes  := '';
        RqOsc.YMax := 1.1;
        edYMax.Text := '';
        edY1Alarm.Text := '';
        edY2Alarm.Text := '';
        stxtGrmNum.Caption := '';
        stxtGrmFreq.Caption := '';
        //   - 
        // -------------------
        if HidenSpectrTab
        then TabSpectr.TabVisible := False;
        // -------------------
    end;
    //  
    RqOsc.Clear;
end;
// =========================================================================
//   
// =========================================================================
// -------------------------------------------------------------------------
//
//     
//    
procedure TConsoleForm.InitSpectrograph(SelectInd : integer);
var DESC : TAppScope;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // -------------------
   with SpectrData
   do begin
      //      
      Scope_Indx   := SelectInd;
      if GetScopeDESC(CurrPtApp, SelectInd, DESC)
      then Scope_Title := DESC.Title
      else Scope_Title := '';
      Signal_ArrIdx := -1;
      Signal_MaxPnt := CurrPtApp^.PtAllConst^.MaxSampNum;
      SetLength(Signal_ArrY, Signal_MaxPnt);
      // -------------------
      //       
      PrBarExtracts.Min := 0;
      PrBarExtracts.Max := Signal_MaxPnt;
      PrBarExtracts.Position := PrBarExtracts.Min;
   end;
end;

// =========================================================================
//     
// =========================================================================
//
//  /  
procedure TConsoleForm.menuHidenShowClick(Sender: TObject);
var SOBJ  : TObject;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   if not (GetScopeSOBJ(CurrPtApp, ModifyInd, SOBJ)) then Exit;
   // ----------------------------------
   with (SOBJ as TCustomScope)
   do Visible := not Visible;
end;
// -------------------------------------------------------------------------
//
//   
procedure TConsoleForm.menuStyleClick(Sender: TObject);
var SOBJ  : TObject;
begin
  // -------------------
  //  
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not (GetScopeSOBJ(CurrPtApp, ModifyInd, SOBJ)) then Exit;
  // -------------------
  //   Line  Switch
  if (SOBJ is TLineScope) or
     (SOBJ is TSwitchScope)
  then begin
     (SOBJ as TCustomScope).Compact := not (SOBJ as TCustomScope).Compact;
     Exit;
  end;
  // -------------------
  //   Ring
  if (SOBJ is TRingScope)
  then begin
    with (SOBJ as TRingScope) do
    begin
       case ScopeStyle of
         ssARC : ScopeStyle := ssPIE;
         ssPIE : ScopeStyle := ssARC;
       end;
    end;
  end;
  // -------------------
end;
// -------------------------------------------------------------------------
//
//  
procedure TConsoleForm.menuTranparentClick(Sender: TObject);
var SOBJ  : TObject;
begin
  // -------------------
  //  
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not (GetScopeSOBJ(CurrPtApp, ModifyInd, SOBJ)) then Exit;
  // -------------------
  with (SOBJ as TCustomScope)
  do Transparent := not Transparent;
  // -------------------
end;
// -------------------------------------------------------------------------
//
//       
procedure TConsoleForm.SetCTRLs (RqSOBJ : TObject; RqCTRL : integer);
var wWallStyle : TWallStyle;  //   
begin
     if not Assigned(RqSOBJ) then Exit;
     if (RqSOBJ is TLineScope) or
        (RqSOBJ is TRingScope) or
        (RqSOBJ is TSwitchScope)
     then begin
         case RqCTRL of
         1 : wWallStyle := wsDam;     //  
         2 : wWallStyle := wsLimit;   //  
         else wWallStyle := wsNotUse; //  
         end;
         (RqSOBJ as TCustomScope).WallStyle := wWallStyle;
     end;
end;
// -------------------------------------------------------------------------
//
//        
procedure TConsoleForm.cmbboxCTRLClick(Sender: TObject);
var SOBJ       : TObject;
    wAlarmMode : TAlarmMode;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   if not (GetScopeSOBJ(CurrPtApp, SelectInd, SOBJ)) then Exit;
   // --------------------
   //   
   SetCTRLs (SOBJ, cmbboxCTRL.ItemIndex);
   // --------------------
   //   
   if Assigned(ALARM01)
   then begin
     case cmbboxCTRL.ItemIndex of
       1 : wAlarmMode := alrmDam;     //  
       2 : wAlarmMode := alrmLimit;   //  
       else wAlarmMode := alrmNotUse; //  
     end;
     ALARM01.AlarmMode := wAlarmMode;
   end;
   // -------------------
end;
// -------------------------------------------------------------------------
//      
// -------------------------------------------------------------------------
//
//  SelectInd   
procedure TConsoleForm.SetSelectInd(Indx : integer);
var DESC  : TAppScope;
begin
      // -------------------
      //  
      if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
      if not (GetScopeDESC(CurrPtApp, Indx, DESC)) then Exit;
      // ---------------------
      SelectInd := Indx;
      cbboxSelectSensor.ItemIndex := SelectInd;
      // ---------------------
      //       
      SetOscParam (Osc01, SelectInd);
      // ---------------------
      //    ALARM -    
      SetAlarmParam (ALARM01, SelectInd);
      // ---------------------
      //    GRID -    
      SetGRIDParam (GRID01, SelectInd);
      // ---------------------
      PrBarExtracts.Position := 0;
      if Assigned(SpectrScope)
      then begin
        //  
        SpectrData.Scope_Indx := SelectInd;
        SpectrData.Signal_ArrIdx := -1;
        SpectrData.Scope_Title := DESC.Title;
        SpectrScope.ClearShow();
        if Assigned(Osc02)
        then begin
            //        
            SetGrmlOscParam (Osc02, SelectInd, Spectr_Inx);
        end;
      end;
end;
// -------------------------------------------------------------------------
//    RqX,RqY  RqRect
function IsXYInRect(const RqRect : TRect; RqX, RqY : integer): boolean;
begin
  Result := (RqX >= RqRect.Left) and (RqX <= RqRect.Right) and
            (RqY >= RqRect.Top)  and (RqY <= RqRect.Bottom);
end;
// -------------------------------------------------------------------------
//
//      X,Y  Img
function TConsoleForm.ClickIndByImgXY(X,Y : integer): integer;
var SOBJ  : TObject;
    Ind   : integer;
begin
   Result := -1;
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // -------------------
   for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
   do begin
      if not (GetScopeSOBJ(CurrPtApp, Ind, SOBJ)) then Continue;
      with (SOBJ as TCustomScope) do
      begin
         if IsXYInRect(ScopeRect, X, Y)
         then begin
            Result :=Ind;
            Exit;
         end;
      end;
   end;
end;
// -------------------------------------------------------------------------
//
//      Image
procedure TConsoleForm.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var SOBJ  : TObject;
    Ind   : integer;
begin
  // -------------------
  //  
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  // --------------------
  //  MouseDown
  StaticText3.Caption := ' ' + IntToStr(X);
  StaticText4.Caption := ' ' + IntToStr(Y);
  // --------------------
  //  PopupMenu
  PopupMenuLR.AutoPopup := False;
  if (Button = mbRight)
  then begin
      ModifyInd := ClickIndByImgXY(X,Y);
      if GetScopeSOBJ(CurrPtApp, ModifyInd, SOBJ)
      then begin
          with (SOBJ as TCustomScope) do
          begin
               if IsXYInRect(ScopeRect, X, Y)
               then begin
                  PopupMenuLR.AutoPopup := True;
                  Exit;
               end;
          end;
      end;
  end;
  // --------------------
  //  SelectInd  
  if (Button = mbLeft)
  then begin
     for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
     do begin
        if not (GetScopeSOBJ(CurrPtApp, Ind, SOBJ)) then Continue;
        with (SOBJ as TCustomScope) do
        begin
           if IsXYInRect(ScopeRect, X, Y)
           then begin
                //  SelectInd  
                SetSelectInd(Ind);
                Exit;
           end;
        end;
     end;
  end;
end;
// -------------------------------------------------------------------------
//
//    ComboBox
procedure TConsoleForm.cbboxSelectSensorClick(Sender: TObject);
begin
   if cbboxSelectSensor.ItemIndex <> SelectInd
   then SetSelectInd(cbboxSelectSensor.ItemIndex);
end;
// -------------------------------------------------------------------------
//       
// -------------------------------------------------------------------------
//
// /  
procedure TConsoleForm.chckOs01OnOfClick(Sender: TObject);
begin
     // -------------------
     //  
     if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
     // -------------------
     if chckOs01OnOf.Checked
     then begin
         if not Assigned(Osc01)
          then begin
             //       
             Osc01 := TOscillograph.Create(CurrPtApp^.PtAllConst^.Osc01Width,
                                           CurrPtApp^.PtAllConst^.Osc01Heigth);
             //        
             SetOscParam (Osc01, SelectInd);
          end;
     end
     else begin
         if Assigned(Osc01)
          then begin
             Osc01.Free;
             Osc01 := nil;
          end;
     end;
end;
// -------------------------------------------------------------------------
//
// / ALARM -  
procedure TConsoleForm.chckAlarmOnOfClick(Sender: TObject);
begin
     // -------------------
     //  
     if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
     // -------------------
     if chckAlarmOnOf.Checked
     then begin
         if not Assigned(ALARM01)
          then begin
             //  ALARM - 
             ALARM01 := TDnAlarm.Create(CurrPtApp^.PtAllConst^.AlarmWidth,
                                        CurrPtApp^.PtAllConst^.AlarmHeight);
             //    ALARM -    
             SetAlarmParam (ALARM01, SelectInd);
          end;
     end
     else begin
         if Assigned(ALARM01)
          then begin
             ALARM01.Free;
             ALARM01 := nil;
          end;
     end;
end;
// -------------------------------------------------------------------------
//
// / GRID - 
procedure TConsoleForm.chckGridOnOfClick(Sender: TObject);
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // -------------------
   if chckGridOnOf.Checked
   then begin
      if not Assigned(GRID01)
      then begin
         GRID01 := TDnGridEd.Create(260,260,False);
         //    
         with GRID01 do
         begin
             RowMaxInd   := 11;
             //---------
             RowTitle[1] := ' Xb (pix)';
             RowTitle[2] := ' Yb (pix)';
             //---------
             RowTitle[3] := ' Min. ';
             RowTitle[4] := '  (-) ';
             RowTitle[5] := '   (-)  ';
             //---------
             RowTitle[6] := '  ';
             GRID01_ValueRow := 6;
             //---------
             RowTitle[7] := '   (+)  ';
             RowTitle[8] := '  (+)  ';
             RowTitle[9] := ' Max. ';
             //---------
             RowTitle[10] := '    ';
             RowTitle[11] := '  1 (msec) ';
         end;
         //    GRID -    
         SetGRIDParam (GRID01, SelectInd);
      end;
   end
   else begin
      if Assigned(GRID01)
      then begin
         GRID01.Free;
         GRID01 := nil;
      end;
   end;
end;
// =========================================================================
//  /       
// =========================================================================
//
//      
procedure TConsoleForm.ShowSensors();
var DESC   : TAppScope;
    SOBJ   : TObject;
    Ind    : integer;
    wValue : extended;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // -------------------
   //    
   StTxtFullTime.Caption := StartMMTimeStamp (FullStamps);
   // -------------------
   //   
   for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
   do begin
      if not(GetScopeSOBJ(CurrPtApp, Ind, SOBJ)) then Continue;
      with (SOBJ as TCustomScope) do
      begin
          wValue := DataBuffer.BufArr[Ind].Value;
          if Assigned(SOBJ) then Value := wValue;
      end;
   end;
   // -------------------
   wValue := DataBuffer.BufArr[SelectInd].Value;    //***
   // -------------------
   //     
   if Assigned(Osc01)
   then begin
     Osc01.AddNewData(wValue);
   end;
   // -------------------
   //   ALARM - 
   if Assigned(ALARM01)
   then begin
     ALARM01.Value := wValue;
   end;
   // -------------------
   //   GRID - 
   if Assigned(GRID01)
   then begin
     GRID01.CellsStr[1,GRID01_ValueRow] := FloatToStr(wValue);
   end;
   // -------------------
   //   
   if not (GetScopeDESC(CurrPtApp, SelectInd, DESC)) then Exit;
   if DESC.Grm1P > 0
   then begin
      // ----------------------------------
      //        
      //      
      AddSignalPoint(wValue, SpectrData);
   end;
   // -------------------
   //       
   StTxtFullTime.Caption := StopMMTimeStamp (FullStamps);
   // -------------------
end;

// --------------------------------------------------------------------
//
//    
procedure TConsoleForm.spbtnVisibleAllScopeClick(Sender: TObject);
var SOBJ  : TObject;
    Ind   : integer;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // -------------------
   for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
   do begin
      if not (GetScopeSOBJ(CurrPtApp, Ind, SOBJ)) then Continue;
      //   
      (SOBJ as TCustomScope).Visible := True;
  end;
end;
// ====================================================================
//     TSpectrScope  
// ====================================================================

// --------------------------------------------------------------------
//
//          
procedure TConsoleForm.AddSignalPoint(RqVal : extended;
                           var RqSpectrData : TSpectrData);
var DESC  : TAppScope;
begin
  // -------------------
  //  
  if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
  if not GetScopeDESC(CurrPtApp, SelectInd, DESC) then Exit;
  // -------------------
  with SpectrData
  do begin
    Inc(Signal_ArrIdx);
    if Signal_ArrIdx > High(Signal_ArrY)
    then begin
       if Assigned(DTF03)
       then begin
          // -------------------
          //    
          StTxtDFTTime.Caption := StartMMTimeStamp (DFTStamps);
          // -------------------
          //  
          DTF03.CodMet := 0;             //   
          DTF03.RqDegree := False;       //    
          DTF03.XB := 0;                 //    
          if DESC.Grm1P > 0
          then DTF03.XE := DESC.Grm1P
          else DTF03.XE := 1;            //     ( msec)
          DTF03.RunDTF03(Signal_ArrY);   //   
          // -------------------
          //       
          StTxtDFTTime.Caption := StopMMTimeStamp (DFTStamps);
          // -------------------
          //  
          if Assigned (SpectrScope)
          then begin
              ShowSpectrScope(RqSpectrData);
              SpectrScope.SelectNum := Spectr_Inx;
              if Assigned(Osc02)
              then begin
                  Osc02.AddNewData(DTF03.Cn[Spectr_Inx]);
              end;
          end;
          // -------------------
       end;
       Signal_ArrIdx := -1;               //  
    end
    else begin
      //     
      Signal_ArrY[Signal_ArrIdx] := RqVal;
    end;
    //   
    PrBarExtracts.Position := Signal_ArrIdx;
  end; // with
  // -------------------
end;
// --------------------------------------------------------------------
//         
procedure TConsoleForm.ShowSpectrScope(var RqSpectrData : TSpectrData);
var Ind : integer;
begin
   //  
   if not Assigned(DTF03) then Exit;
   if not Assigned(SpectrScope) then Exit;
   //       
   if DTF03.MaxIndGgm < 0 then Exit;
   Spectr_MaxAmp := 0;
   SetLength(RqSpectrData.Spectr_Arr, DTF03.MaxIndGgm + 1);
   for Ind := 0 to DTF03.MaxIndGgm
   do begin
      //    SpectrScope
      RqSpectrData.Spectr_Arr[Ind].Amp := DTF03.Cn[Ind];
      RqSpectrData.Spectr_Arr[Ind].Phs := DTF03.Pn[Ind];
   end;
   //      
   SpectrScope.ArrSpectr := RqSpectrData.Spectr_Arr;
   //    
   SpectrScope.Show;
end;
// --------------------------------------------------------------------
//       
procedure TConsoleForm.spbuttAplyAmpClick(Sender: TObject);
var wExt : extended;
begin
  if Assigned(Osc02)
  then begin
      if TryStrToFloat(edYMax.Text,wExt)
      then begin
         Osc02.YMax  := wExt;
         Osc02.GridY := wExt/5;
      end;
      if TryStrToFloat(edY1Alarm.Text,wExt)
      then Osc02.P1Wall := wExt;
      if TryStrToFloat(edY2Alarm.Text,wExt)
      then Osc02.P2Wall := wExt;
      Osc02.ReShow;
   end;
end;
// --------------------------------------------------------------------
//         Y
function YFormatString(RqVal : extended): string;
begin
   Result := '%5.5f';
   if (RqVal > 10000)
   then begin Result := '%5.0f'; Exit; end;
   if (RqVal >= 1000)
   then begin Result := '%5.1f'; Exit; end;
   if (RqVal >= 100)
   then begin Result := '%5.2f'; Exit; end;
   if (RqVal >= 10)
   then begin Result := '%5.3f'; Exit; end;
   if (RqVal >= 1)
   then begin Result := '%5.4f'; Exit; end;
   if (RqVal >= 0.1)
   then begin Result := '%5.5f'; Exit; end;
end;
// --------------------------------------------------------------------
//
//   Y -     
procedure TConsoleForm.spbuttOptimalScaleClick(Sender: TObject);
const Eps = 1e-6;
var DESC    : TAppScope;
    wExt    : extended;
    wFrmStr : string;
begin
   // -------------------
   //  
   if not Assigned(Osc02) then Exit;
   if not Assigned(DTF03) then Exit;
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   if not GetScopeDESC(CurrPtApp, SelectInd, DESC) then Exit;
   // -------------------
   //     
   wExt := DTF03.MaxAmpGrm;
   if wExt > Eps
   then begin
      Osc02.YMax  := wExt;
      Osc02.GridY := wExt/5;
      try
        Osc02.P1Wall := wExt * DESC.P1Y / DESC.Max;
        Osc02.P2Wall := wExt * DESC.P2R / DESC.Max;
      except
        Osc02.P1Wall := wExt;
        Osc02.P2Wall := wExt;
      end;
      wFrmStr := YFormatString(wExt);
      edYMax.Text := Format(wFrmStr, [wExt]);
      wFrmStr := YFormatString(Osc02.P1Wall);
      edY1Alarm.Text := Format(wFrmStr, [Osc02.P1Wall]);  //  
      wFrmStr := YFormatString(Osc02.P2Wall);
      edY2Alarm.Text := Format(wFrmStr, [Osc02.P2Wall]);  //  
      Osc02.YMax  := wExt * 1.1;
   end;

end;
// --------------------------------------------------------------------
//    
procedure TConsoleForm.spbuttClearHistoryClick(Sender: TObject);
begin
  if Assigned(Osc02) then Osc02.Clear;
end;

// =========================================================================
//   
// =========================================================================
// --------------------------------------------------------------------
//   "   "
procedure  TConsoleForm.SpectrLoad(Sender : TObject; ArrGrm : TArrSpectr);
begin
//     
end;
// --------------------------------------------------------------------
//   "   Free"
procedure TConsoleForm.SpecrtDestroy(Sender : TObject);
begin
//     
end;
// --------------------------------------------------------------------
//
//   "  "
procedure TConsoleForm.ShowSelectGrm (Sender: TObject;
                                Num : integer; ArrGrm : TArrSpectr);
var DESC  : TAppScope;
    wFreq : extended;
begin
   if Spectr_Inx <> Num
   then begin
      Spectr_Inx := Num;
      if Assigned(Osc02)
      then begin
        //        
       SetGrmlOscParam (Osc02, SelectInd, Spectr_Inx);
       end;
       //     
       stxtGrmFreq.Caption := '';
       stxtGrmNum.Caption := IntToStr(Num);
       if not (GetScopeDESC(CurrPtApp, SelectInd, DESC)) then Exit;
       if DESC.Grm1P > 0
       then begin
         try
            //   ( msec)   (Hz)
            wFreq := (1/DESC.Grm1P) * 1000 *  Num;
            stxtGrmFreq.Caption := FloatToStr(wFreq) + ' Hz';
         except
            stxtGrmFreq.Caption := '';
         end;
       end;
   end;
end;
// -------------------------------------------------------------------------
//
procedure TConsoleForm.CreateSpectrograph();
begin
   //     
   if not Assigned(DTF03)
   then DTF03 := TDTF03.Create;
   //   SpectrScope -  
   if not Assigned(SpectrScope)
   then begin
     SpectrScope := TSpectrScope.Create(PanelSpectr);
     //      
     SpectrScope.DialogLoadSpectrOnOff(False);
     // --------------------
     //    "   "
     //        
     SpectrScope.OnSpectrLoad := SpectrLoad;
     // --------------------
     //    "   Free"
     //       
     SpectrScope.OnSpecrtDestroy := SpecrtDestroy;
     // --------------------
     //    "  "
     //        
     SpectrScope.OnGrmSelect  := ShowSelectGrm;
  end;
  //      
  if not Assigned(Osc02)
  then begin
       Osc02 := TOscillograph.Create(PanelOS2);
       //        
       SetGrmlOscParam (Osc02, SelectInd, 0);
   end;
end;

// =========================================================================
//   / 
// =========================================================================
// -------------------------------------------------------------------------
// 11.01.2020
//       
procedure ClearImage(RqImg : TImage; RqColor : TColor);
var wColor : TColor;
    wSize  : integer;
begin
  with RqImg.Canvas
  do begin
    Brush.Color := RqColor;
    FillRect(Rect(0,0, RqImg.Width, RqImg.Height));
    Font.Style := [fsBold];
    wSize  := Font.Size;
    wColor := Font.Color;
    Font.Size := 10;
    Font.Color := RGB(128,0,0);
    TextOut(40, 20, 'ERROR:      ...');
    Font.Color := wColor;
    Font.Size  := wSize;
    Font.Style := [];
  end;
end;
// -------------------------------------------------------------------------
// 11.01.2020
//     
//  
function TConsoleForm.OpenConsole(RqAppInd : integer) : integer;
var DESC  : TAppScope;
    SOBJ  : TObject;
    XB, YB  : integer;
    Ind     : integer;
begin
   Result := -1;
   // --------------------
   //     
   if (CurrAppIndx >= 0) and (CurrPtApp  <> nil)
   then CloseConsole();
   // --------------------
   //    
   // --------------------
   //       RqAppInd
   CurrPtApp := TestPtApp(RqAppInd);
   if CurrPtApp = nil
   then begin
      CurrAppIndx := -1;
      cbboxSelectSensor.Clear;
      ClearImage(Image1, ScrollBox1.Color);
      //    
      Caption := '  ';
      Exit;
   end;
   //  
   CurrAppIndx := RqAppInd;
   // --------------------
   //     
   // --------------------
   try
      with CurrPtApp^.PtAllConst^ do
      begin
         // --------------------
         //    
         Caption := AppType + AppName  + AppVers
                  + ' (C) ' + AppAutor + AppCopyR;
         // --------------------
         //   
         if Assigned(ImgLoadSave1)
         then ImgLoadSave1.LoadImgFromFile(ApplicationDirectory + ImgFileName,
                                           Image1);
         Image1.AutoSize := False;
         Image1.Width  := ImgWidth;
         Image1.Height := ImgHeight;
       end;
       // --------------------
       //    
       cbboxSelectSensor.Clear;
       // --------------------
       for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
       do begin
         if not GetScopeDESC(CurrPtApp, Ind, DESC) then Continue;
         // --------------------
         //    
         cbboxSelectSensor.Items.Add(DESC.Title);
         XB := DESC.Xb;
         YB := DESC.YB;
         // --------------------
         SOBJ := nil;
         case DESC.SType of
         'L' : SOBJ := TLineScope.Create(Image1,XB,YB);
         'R' : SOBJ := TRingScope.Create(Image1,XB,YB);
         'S' : SOBJ := TSwitchScope.Create(Image1,XB,YB);
         end;
         CurrPtApp^.ArrSOBJ[Ind] := SOBJ;
         // --------------------
         if Assigned(SOBJ)
         then begin
            with SOBJ do
            begin
              //    
              if (SOBJ is TLineScope)
              then SetLineScopeParam (Ind);
              if (SOBJ is TRingScope)
              then SetRingScopeParam (Ind);
              if (SOBJ is TSwitchScope)
              then SetSwitchScopeParam (Ind);
            end;
         end;
       end; // of for
       //    
       SelectInd := 0;
       //    
       cbboxSelectSensor.ItemIndex := SelectInd;
       //     
       //    
       InitSpectrograph(SelectInd);
       SetGrmlOscParam (Osc02, SelectInd, 0);
       // --------------------
       //    
       Result := RqAppInd;
       // --------------------
   except
       MessageDlg('function OpenConsole ERROR :'
       + #13#10 + '   ',
                  mtError, [mbOk], 0);
   end;
end;

// -------------------------------------------------------------------------
// 11.01.2020
//    
procedure TConsoleForm.CloseConsole();
var SOBJ      : TObject;
    LineOBJ   : TLineScope;
    RingOBJ   : TRingScope;
    SwitchOBJ : TSwitchScope;
    Ind       : integer;
begin
   // -------------------
   //  
   if (CurrAppIndx < 0) or (CurrPtApp = nil) then Exit;
   // --------------------
   //   
   for Ind := Low(CurrPtApp^.ArrSOBJ) to High(CurrPtApp^.ArrSOBJ)
   do begin
      SOBJ := CurrPtApp^.ArrSOBJ[Ind];
      if Assigned(SOBJ)
      then begin
         if (SOBJ is TLineScope)
         then begin
            LineOBJ :=  TLineScope(SOBJ);
            LineOBJ.Visible := False;
            LineOBJ.Free;
            Continue;
         end;
         if (SOBJ is TRingScope)
         then begin
            RingOBJ := TRingScope(SOBJ);
            RingOBJ.Visible := False;
            RingOBJ.Free;
            Continue;
         end;
         if (SOBJ is TSwitchScope)
         then begin
            SwitchOBJ := TSwitchScope(SOBJ);
            SwitchOBJ.Visible := False;
            SwitchOBJ.Free;
         end;
         Image1.Refresh;
      end;
      CurrPtApp^.ArrSOBJ[Ind] := nil;
   end;
   // --------------------
   //     
   if Assigned(Osc01)
   then begin
      Osc01.Free;
      Osc01 := nil;
      chckOs01OnOf.Checked := False;
   end;
   // --------------------
   //  ALARM - 
   if Assigned(ALARM01)
   then begin
       ALARM01.Free;
       ALARM01 := nil;
       chckAlarmOnOf.Checked := False;
   end;
   // --------------------
   //  GRID - 
   if Assigned(GRID01)
   then begin
       GRID01.Free;
       GRID01 := nil;
       chckGridOnOf.Checked := False;
   end;
   // --------------------
   //   
   if Assigned(SpectrScope)
   then begin
      SpectrScope.ClearShow;
   end;
   // --------------------
   //    
   if Assigned(Osc02)
   then begin
      Osc02.Clear;
   end;
   // --------------------
   //  
   // --------------------
   CurrPtApp   := nil;
   CurrAppIndx := -1;
   // --------------------
end;

// -------------------------------------------------------------------------
// 11.01.2020
//  
procedure TConsoleForm.FormCreate(Sender: TObject);
begin
    // --------------------
    //    
    ImgLoadSave1 := TLoadSaveImage.Create(nil,nil);
    // --------------------
    //    
    SelectInd := 0;
    CreateSpectrograph();
    InitSpectrograph(SelectInd);
    // --------------------
    //    
    OpenConsole(0);
    // --------------------
end;
// -------------------------------------------------------------------------
// 11.01.2020
//      
procedure TConsoleForm.FormDestroy(Sender: TObject);
begin
  // --------------------
  CloseConsole();
  // --------------------
  //     
  if Assigned(DTF03)
  then begin
     DTF03.Free;
     DTF03 := nil;
  end;
  // --------------------
  //   
  if Assigned(SpectrScope)
   then begin
      SpectrScope.Free;
      SpectrScope := nil;
   end;
   // --------------------
   //    
   if Assigned(Osc02)
   then begin
      Osc02.Free;
      Osc02 := nil;
   end;
   // --------------------
   //    /  
   if Assigned(ImgLoadSave1) then ImgLoadSave1.Free;
   // --------------------
end;

// =========================================================================
//  
// =========================================================================


end.
